import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { Code, Palette, Database, Calendar, CheckCircle, FileText, Users, Award, Zap, Clock } from 'lucide-react'
import ImageSlider from '../components/ImageSlider'
import './Enroll.css'

const Enroll = () => {
  const navigate = useNavigate()
  const [selectedCourse, setSelectedCourse] = useState('')
  const [startDate, setStartDate] = useState('')
  const [isSubmitted, setIsSubmitted] = useState(false)

  const courses = [
    { 
      id: 'algorithms', 
      name: 'Основы алгоритмизации и программирования', 
      icon: Code,
      color: '#2563EB',
      description: 'Изучите основы программирования, алгоритмы и структуры данных. Начните свой путь в IT с нуля.',
      duration: '120 часов',
      level: 'Начальный',
      students: '2500+',
      rating: '4.9'
    },
    { 
      id: 'web-design', 
      name: 'Основы веб-дизайна', 
      icon: Palette,
      color: '#7C3AED',
      description: 'Создавайте красивые и функциональные веб-интерфейсы. Изучите UI/UX дизайн и современные инструменты.',
      duration: '100 часов',
      level: 'Начальный',
      students: '1800+',
      rating: '4.8'
    },
    { 
      id: 'databases', 
      name: 'Основы проектирования баз данных', 
      icon: Database,
      color: '#10B981',
      description: 'Освойте проектирование и работу с базами данных. SQL, нормализация, оптимизация запросов.',
      duration: '140 часов',
      level: 'Средний',
      students: '1200+',
      rating: '4.9'
    }
  ]

  const handleSubmit = (e) => {
    e.preventDefault()
    
    if (!selectedCourse || !startDate) {
      alert('Пожалуйста, выберите курс и дату начала обучения')
      return
    }

    const saved = localStorage.getItem('courseApplications')
    const applications = saved ? JSON.parse(saved) : []
    
    const courseData = courses.find(c => c.id === selectedCourse)
    
    const newApplication = {
      id: Date.now(),
      courseName: courseData.name,
      startDate: startDate,
      status: 'active',
      review: null
    }
    
    applications.push(newApplication)
    localStorage.setItem('courseApplications', JSON.stringify(applications))
    
    setIsSubmitted(true)
    
    setTimeout(() => {
      navigate('/')
    }, 2000)
  }

  const today = new Date()
  const maxDate = new Date(today.getTime() + 90 * 24 * 60 * 60 * 1000)
  const minDateStr = today.toISOString().split('T')[0]
  const maxDateStr = maxDate.toISOString().split('T')[0]

  return (
    <div className="enroll-page-brutal">
      <div className="container">
        <section className="enroll-header-brutal">
          <h1 className="enroll-title-brutal">Запись на курс</h1>
          <p className="enroll-description-brutal">
            Все курсы включают практические задания, обратную связь от преподавателей и сертификат по завершении
          </p>
        </section>

        <section className="enroll-form-section-brutal">
          <form className="form-brutal" onSubmit={handleSubmit}>
            <div className="courses-selection-brutal">
              {courses.map((course) => {
                const Icon = course.icon
                return (
                  <button
                    key={course.id}
                    type="button"
                    className={`course-card-brutal ${selectedCourse === course.id ? 'selected' : ''}`}
                    onClick={() => setSelectedCourse(course.id)}
                    style={{ '--course-color': course.color }}
                  >
                    <div className="course-card-header-brutal">
                      <div className="course-icon-brutal">
                        <Icon size={32} />
                      </div>
                      {selectedCourse === course.id && (
                        <div className="check-badge-brutal">
                          <CheckCircle size={24} />
                        </div>
                      )}
                    </div>
                    <h3 className="course-name-brutal">{course.name}</h3>
                    <p className="course-desc-brutal">{course.description}</p>
                    <div className="course-stats-brutal">
                      <div className="course-stat-brutal">
                        <Clock size={16} />
                        <span>{course.duration}</span>
                      </div>
                      <div className="course-stat-brutal">
                        <Users size={16} />
                        <span>{course.students}</span>
                      </div>
                      <div className="course-stat-brutal">
                        <Award size={16} />
                        <span>{course.rating}</span>
                      </div>
                    </div>
                    <div className="course-level-brutal">
                      <span>{course.level}</span>
                    </div>
                  </button>
                )
              })}
            </div>

            {selectedCourse && (
              <div className="date-section-brutal">
                <div className="date-label-brutal">
                  <Calendar size={20} />
                  <span>Дата начала занятий</span>
                </div>
                <input
                  type="date"
                  className="date-input-brutal"
                  value={startDate}
                  onChange={(e) => setStartDate(e.target.value)}
                  min={minDateStr}
                  max={maxDateStr}
                  required
                />
              </div>
            )}

            <button 
              type="submit" 
              className="submit-btn-brutal" 
              disabled={!selectedCourse || !startDate || isSubmitted}
            >
              <span>Подать заявку</span>
            </button>

            {isSubmitted && (
              <div className="success-message-brutal">
                <CheckCircle size={32} />
                <span>Заявка успешно отправлена!</span>
              </div>
            )}
          </form>
        </section>

        <ImageSlider />

        <section className="benefits-brutal">
          <h2 className="benefits-title-brutal">Преимущества обучения</h2>
          <div className="benefits-grid-brutal">
            <div className="benefit-item-brutal">
              <div className="benefit-icon-brutal">
                <FileText size={28} />
              </div>
              <h3 className="benefit-title-brutal">Практические задания</h3>
              <p className="benefit-text-brutal">Реальные проекты и кейсы из индустрии</p>
            </div>
            <div className="benefit-item-brutal">
              <div className="benefit-icon-brutal">
                <Users size={28} />
              </div>
              <h3 className="benefit-title-brutal">Обратная связь</h3>
              <p className="benefit-text-brutal">Персональные консультации с преподавателями</p>
            </div>
            <div className="benefit-item-brutal">
              <div className="benefit-icon-brutal">
                <Award size={28} />
              </div>
              <h3 className="benefit-title-brutal">Сертификат</h3>
              <p className="benefit-text-brutal">Официальный документ по завершении курса</p>
            </div>
            <div className="benefit-item-brutal">
              <div className="benefit-icon-brutal">
                <Zap size={28} />
              </div>
              <h3 className="benefit-title-brutal">Карьерная поддержка</h3>
              <p className="benefit-text-brutal">Помощь в трудоустройстве после обучения</p>
            </div>
          </div>
        </section>
      </div>
    </div>
  )
}

export default Enroll

